SET TERM ^ ;

CREATE OR ALTER PROCEDURE TROVAPREZZICONSCONTIPV (
    CLIENTE Varchar(10),
    ARTICOLO Varchar(20),
    ESTENSIONE Varchar(3),
    QUANTITA Decimal(15,2),
    DATA Date )
RETURNS (
    PREZZONETTO Decimal(15,6),
    PREZZOSCONTATO Decimal(15,6),
    SCONTO Decimal(15,2),
    SCONTOUNO Decimal(15,2),
    SCONTODUE Decimal(15,2),
    SCONTOTRE Decimal(15,2),
    LISTINO_RIF Integer,
    LISTINO_APP Integer,
    PROVVIGIONE Decimal(15,3),
    OMA_SOGLIA Integer,
    OMA_CODICE Varchar(20),
    OMA_ESTENSIONE Varchar(3),
    OMA_QUANTITA Integer,
    OMA_MULTIPLI Integer,
    PRIORITA_SU_ECCPROVV Smallint,
    IDPROMOVELOCE Integer,
    SCONTOPROMOVELOCE Decimal(15,2),
    QSTOCKUTILE Integer,
    PREZZOPROMOSTOCK Decimal(15,6) )
AS
declare variable FASCIA integer;
declare variable COUNTER integer;
declare variable MIGLIORPREZZOMODE smallint;
declare variable VLISTINO integer;
declare variable NLISTINI integer;
declare variable DSQL varchar(700);
declare variable SCONTOSP decimal(15,2);
declare variable SCONTOUNOSP decimal(15,2);
declare variable SCONTODUESP decimal(15,2);
declare variable SCONTOTRESP decimal(15,2);
declare variable PROVVIGIONESP decimal(15,3);
declare variable PRIORITA_SU_ECCPROVVSP smallint;
declare variable RICARICOSP decimal(15,2);
declare variable RICARICOUNOSP decimal(15,2);
declare variable RICARICODUESP decimal(15,2);
declare variable RICARICOTRESP decimal(15,2);
declare variable MIGLIORPREZZONETTO decimal(15,6);
declare variable MIGLIORPREZZOSCONTATO decimal(15,6);
declare variable MIGLIORSCONTO decimal(15,2);
declare variable MIGLIORSCONTOUNO decimal(15,2);
declare variable MIGLIORSCONTODUE decimal(15,2);
declare variable MIGLIORSCONTOTRE decimal(15,2);
declare variable MIGLIORLISTINORIF integer;
declare variable MIGLIORLISTINOAPP integer;
declare variable MIGLIORPROVVIGIONE decimal(15,3);
declare variable LISTINOPREZZIVENDITA integer;
declare variable SCONTOSPECIALE1TROVATO smallint;
declare variable SCONTOSPECIALE2TROVATO smallint;
declare variable OMAGGIOSPECIALE1TROVATO smallint;
declare variable OMAGGIOSPECIALE2TROVATO smallint;
declare variable OMA_SOGLIA_SP integer;
declare variable OMA_CODICE_SP varchar(20);
declare variable OMA_ESTENSIONE_SP varchar(3);
declare variable OMA_QUANTITA_SP integer;
declare variable OMA_MULTIPLI_SP integer;
declare variable IDPROMOVELOCE_SP integer;
declare variable FASCESTOCK integer;
declare variable LISTINOSTOCK integer;
declare variable QTSTOCK integer;
declare variable DATAPROMOSTOCK date;
declare variable QCONSTOCK integer;
    
BEGIN

    --MATTEO 2017 11 08
    DSQL='SELECT COALESCE(TIPOPREZZO,0) FASCIA FROM CLIENTI WHERE (CODICE='''||CLIENTE||''')';
    EXECUTE STATEMENT DSQL INTO FASCIA;
    


    --MATTEO 2012 06 01 se fascia=0 cerco la fascia di default
    IF(FASCIA=0 OR FASCIA IS NULL)THEN
    BEGIN
        DSQL='SELECT CAST(TESTO AS INT) FROM TABX WHERE (NOME=''FasciaDefault'')';
        EXECUTE STATEMENT DSQL INTO FASCIA;
    END

    --MATTEO 2012 03 26 modalita miglior prezzo
    migliorprezzoscontato=NULL;
    MIGLIORPREZZOMODE=0;
    DSQL='SELECT COUNT(*) '||
        'FROM    FASCESC '||
        'WHERE   FASCESC.ID='||fascia||' AND FASCESC.CLASSIFICAZIONE1=''MIGLIORPR''';
        EXECUTE STATEMENT DSQL INTO MIGLIORPREZZOMODE;
    IF(MIGLIORPREZZOMODE<>1)THEN
        MIGLIORPREZZOMODE=0;


    --MATTEO 2012 03 20
    --CONTO QUANTI LISTINI CI SONO PER QUESTA FASCIA
    DSQL='SELECT   MAX(FASCESCDT.NRIGA) '||
        'from    FASCESC '||
        'join    FASCESCDT '||
        'ON      FASCESCDT.IDFASCIA=FASCESC.ID '||
        'join    LISTSC '||
        'ON      LISTSC.ID =FASCESCDT.IDLISTINO '||
        'WHERE   (LISTSC.DATAINIZIOVALIDITA IS NULL OR LISTSC.DATAINIZIOVALIDITA<='''||DATA||''') '||
        'AND     (LISTSC.DATAFINEVALIDITA IS NULL OR '''||DATA||'''<=LISTSC.DATAFINEVALIDITA) '||
        'and   FASCESC.ID='||fascia||'';
        EXECUTE STATEMENT DSQL INTO NLISTINI;


    FOR
        SELECT   LISTSC.ID
        FROM    FASCESC
        JOIN    FASCESCDT
        ON      FASCESCDT.IDFASCIA=FASCESC.ID
        JOIN    LISTSC
        ON      LISTSC.ID =FASCESCDT.IDLISTINO
        WHERE   (LISTSC.DATAINIZIOVALIDITA IS NULL OR LISTSC.DATAINIZIOVALIDITA<=:DATA)
        AND     (LISTSC.DATAFINEVALIDITA IS NULL OR :DATA<=LISTSC.DATAFINEVALIDITA)
        AND   FASCESC.ID=:fascia
        ORDER BY FASCESCDT.NRIGA,listsc.DATAINIZIOVALIDITA
        INTO    :vLISTINO
    --MATTEO 2012 03 20
    --FINCHE NON HO TROVATO UN PREZZO PER OGNI LISTINO CERCO SE ESISTE UN PREZZO    
    DO BEGIN
        IF(MIGLIORPREZZOMODE=1 OR prezzoscontato IS NULL OR prezzoscontato=-1)THEN
        BEGIN
            EXECUTE PROCEDURE TROVAPREZZO_LISTINO(:FASCIA,:ARTICOLO,:ESTENSIONE,:DATA,:QUANTITA,:vLISTINO,0)
            RETURNING_VALUES  :prezzonetto,
                              :prezzoscontato,
                              :sconto,
                              :scontouno,
                              :scontodue,
                              :scontotre,
                              :listino_rif,
                              :Listino_app,
                              :provvigione,
                              :OMA_SOGLIA,
                              :OMA_CODICE,
                              :OMA_ESTENSIONE,
                              :OMA_QUANTITA,
                              :OMA_MULTIPLI,
                              :PRIORITA_SU_ECCPROVV,
                              :IDPROMOVELOCE;
            IF (prezzonetto*prezzoscontato IS NOT NULL AND prezzoscontato<>-1) 
            THEN BEGIN

                --SE SCONTI NULL LI IMPOSTO A ZERO
                IF(sconto IS NULL)THEN
                   sconto=0;
                IF(scontouno IS NULL)THEN
                   scontouno=0;
                IF(scontodue IS NULL)THEN
                   scontodue=0;
                IF(scontotre IS NULL)THEN
                   scontotre=0;
                   
                SCONTOSPECIALE1TROVATO = 0;
                SCONTOSPECIALE2TROVATO = 0;   
                OMAGGIOSPECIALE1TROVATO = 0;
                OMAGGIOSPECIALE2TROVATO = 0;   

                --CERCO EVENTUALE SCONTO SPECIALE 1 DA APPLICARE
                EXECUTE PROCEDURE APPLICASCONTISPECIALILISTINIPV(1,:CLIENTE,:FASCIA,:ARTICOLO,:ESTENSIONE,:QUANTITA,:DATA)
                RETURNING_VALUES  :scontoSp,
                                  :scontounoSp,
                                  :scontodueSp,
                                  :scontotreSp,
                                  :provvigioneSp,
                                  :OMA_SOGLIA_SP,
                                  :OMA_CODICE_SP,
                                  :OMA_ESTENSIONE_SP,
                                  :OMA_QUANTITA_SP,
                                  :OMA_MULTIPLI_SP,
                                  :PRIORITA_SU_ECCPROVVSP,
                                  :IDPROMOVELOCE_SP;
                IF (scontoSp IS NOT NULL AND scontoSp > 0)
                THEN BEGIN
                        SCONTOSPECIALE1TROVATO = 1;
                        prezzoscontato=prezzoscontato-prezzoscontato*:scontosp/100;
            
                        IF (scontouno IS NULL OR scontouno=0) THEN
                        BEGIN
                           scontouno=scontounosp;
                           scontodue=scontoduesp;
                           scontotre=scontotresp;
                        END
                        ELSE IF (scontodue IS NULL OR scontodue=0) THEN
                        BEGIN
                           scontodue=scontosp;
                        END
                        ELSE IF (scontotre IS NULL OR scontotre=0) THEN
                        BEGIN
                           scontotre=scontosp;
                        END
                        ELSE
                        BEGIN
                           scontotre=100-((100-scontotre)/100*(100-scontounosp)/100*(100-scontoduesp)/100*(100-scontotresp));
                        END
    
                        sconto=100-((100-scontouno)/100*(100-scontodue)/100*(100-scontotre));
                        
                        IF(:IDPROMOVELOCE_SP IS NOT NULL AND :IDPROMOVELOCE_SP>0)THEN
                        BEGIN
                            IDPROMOVELOCE = :IDPROMOVELOCE_SP;
                            SCONTOPROMOVELOCE = :scontoSp;
                        END
                        
                        IF(:PRIORITA_SU_ECCPROVVSP IS NOT NULL AND :PRIORITA_SU_ECCPROVVSP=1)THEN
                        BEGIN
                            provvigione = provvigioneSp;
                            PRIORITA_SU_ECCPROVV = 1;
                        END
                END
                
                IF(OMA_CODICE_SP IS NOT NULL AND OMA_CODICE_SP<>'')THEN
                BEGIN
                    OMAGGIOSPECIALE1TROVATO = 1;
                    OMA_SOGLIA = OMA_SOGLIA_SP;
                    OMA_CODICE = OMA_CODICE_SP;
                    OMA_ESTENSIONE = OMA_ESTENSIONE_SP;
                    OMA_QUANTITA = OMA_QUANTITA_SP;
                    OMA_MULTIPLI = OMA_MULTIPLI_SP;
                END
                
                

                IF(SCONTOSPECIALE1TROVATO = 0)THEN
                BEGIN
                    --CERCO EVENTUALE SCONTO SPECIALE 2 DA APPLICARE
                    EXECUTE PROCEDURE APPLICASCONTISPECIALILISTINIPV(2,:CLIENTE,:FASCIA,:ARTICOLO,:ESTENSIONE,:QUANTITA,:DATA)
                    RETURNING_VALUES  :scontoSp,
                                      :scontounoSp,
                                      :scontodueSp,
                                      :scontotreSp,
                                      :provvigioneSp,
                                      :OMA_SOGLIA_SP,
                                      :OMA_CODICE_SP,
                                      :OMA_ESTENSIONE_SP,
                                      :OMA_QUANTITA_SP,
                                      :OMA_MULTIPLI_SP,
                                      :PRIORITA_SU_ECCPROVVSP,
                                      :IDPROMOVELOCE_SP;
                    IF (scontoSp IS NOT NULL AND scontoSp > 0)
                    THEN BEGIN
                            SCONTOSPECIALE2TROVATO = 1;
                            prezzoscontato=prezzoscontato-prezzoscontato*:scontosp/100;
                
                            IF (scontouno IS NULL OR scontouno=0) THEN
                            BEGIN
                               scontouno=scontounosp;
                               scontodue=scontoduesp;
                               scontotre=scontotresp;
                            END
                            ELSE IF (scontodue IS NULL OR scontodue=0) THEN
                            BEGIN
                               scontodue=scontosp;
                            END
                            ELSE IF (scontotre IS NULL OR scontotre=0) THEN
                            BEGIN
                               scontotre=scontosp;
                            END
                            ELSE
                            BEGIN
                               scontotre=100-((100-scontotre)/100*(100-scontounosp)/100*(100-scontoduesp)/100*(100-scontotresp));
                            END
        
                            sconto=100-((100-scontouno)/100*(100-scontodue)/100*(100-scontotre));
                            
                            IF(:IDPROMOVELOCE_SP IS NOT NULL AND :IDPROMOVELOCE_SP>0)THEN
                            BEGIN
                                IDPROMOVELOCE = :IDPROMOVELOCE_SP;
                                SCONTOPROMOVELOCE = :scontoSp;
                            END
                        
                            IF(:PRIORITA_SU_ECCPROVVSP IS NOT NULL AND :PRIORITA_SU_ECCPROVVSP=1)THEN
                            BEGIN
                                provvigione = provvigioneSp;
                                PRIORITA_SU_ECCPROVV = 1;
                            END
                    END
                        
                    IF(OMAGGIOSPECIALE1TROVATO = 0 AND OMA_CODICE_SP IS NOT NULL AND OMA_CODICE_SP<>'')THEN
                    BEGIN
                        OMAGGIOSPECIALE2TROVATO = 1;
                        OMA_SOGLIA = OMA_SOGLIA_SP;
                        OMA_CODICE = OMA_CODICE_SP;
                        OMA_ESTENSIONE = OMA_ESTENSIONE_SP;
                        OMA_QUANTITA = OMA_QUANTITA_SP;
                        OMA_MULTIPLI = OMA_MULTIPLI_SP;
                    END
                END

                IF(SCONTOSPECIALE1TROVATO = 0 AND SCONTOSPECIALE2TROVATO = 0)THEN
                BEGIN
                    --CERCO EVENTUALE SCONTO SPECIALE 2 DA APPLICARE
                    EXECUTE PROCEDURE APPLICASCONTISPECIALILISTINIPV(3,:CLIENTE,:FASCIA,:ARTICOLO,:ESTENSIONE,:QUANTITA,:DATA)
                    RETURNING_VALUES  :scontoSp,
                                      :scontounoSp,
                                      :scontodueSp,
                                      :scontotreSp,
                                      :provvigioneSp,
                                      :OMA_SOGLIA_SP,
                                      :OMA_CODICE_SP,
                                      :OMA_ESTENSIONE_SP,
                                      :OMA_QUANTITA_SP,
                                      :OMA_MULTIPLI_SP,
                                      :PRIORITA_SU_ECCPROVVSP,
                                      :IDPROMOVELOCE_SP;
                    IF (scontoSp IS NOT NULL AND scontoSp > 0)
                    THEN BEGIN
                            --SCONTOSPECIALE3TROVATO = 1;
                            prezzoscontato=prezzoscontato-prezzoscontato*:scontosp/100;
                
                            IF (scontouno IS NULL OR scontouno=0) THEN
                            BEGIN
                               scontouno=scontounosp;
                               scontodue=scontoduesp;
                               scontotre=scontotresp;
                            END
                            ELSE IF (scontodue IS NULL OR scontodue=0) THEN
                            BEGIN
                               scontodue=scontosp;
                            END
                            ELSE IF (scontotre IS NULL OR scontotre=0) THEN
                            BEGIN
                               scontotre=scontosp;
                            END
                            ELSE
                            BEGIN
                               scontotre=100-((100-scontotre)/100*(100-scontounosp)/100*(100-scontoduesp)/100*(100-scontotresp));
                            END
        
                            sconto=100-((100-scontouno)/100*(100-scontodue)/100*(100-scontotre));
                        
                            IF(:IDPROMOVELOCE_SP IS NOT NULL AND :IDPROMOVELOCE_SP>0)THEN
                            BEGIN
                                IDPROMOVELOCE = :IDPROMOVELOCE_SP;
                                SCONTOPROMOVELOCE = :scontoSp;
                            END
                        
                            IF(:PRIORITA_SU_ECCPROVVSP IS NOT NULL AND :PRIORITA_SU_ECCPROVVSP=1)THEN
                            BEGIN
                                provvigione = provvigioneSp;
                                PRIORITA_SU_ECCPROVV = 1;
                            END
                    END
                        
                    IF(OMAGGIOSPECIALE1TROVATO = 0 AND OMAGGIOSPECIALE2TROVATO = 0 AND OMA_CODICE_SP IS NOT NULL AND OMA_CODICE_SP<>'')THEN
                    BEGIN
                        OMA_SOGLIA = OMA_SOGLIA_SP;
                        OMA_CODICE = OMA_CODICE_SP;
                        OMA_ESTENSIONE = OMA_ESTENSIONE_SP;
                        OMA_QUANTITA = OMA_QUANTITA_SP;
                        OMA_MULTIPLI = OMA_MULTIPLI_SP;
                    END
                END
        
                
                --MATTEO 2013 01 07
                DSQL='SELECT COALESCE(CAST(TESTO AS INT),0) FROM TABX WHERE (NOME=''IDListStoPrVen'')';
                EXECUTE STATEMENT DSQL INTO LISTINOPREZZIVENDITA;
                
                
                SELECT   COUNT(*) C
                FROM    LISTSC
                WHERE   (LISTSC.ID=:LISTINO_APP) AND (LISTSC.TIPO='N')
                INTO    :COUNTER;
                IF ((:COUNTER=1) AND (:LISTINOPREZZIVENDITA<>:LISTINO_APP)) THEN
                BEGIN
                    --CERCO EVENTUALE SCONTO SPECIALE NETTO DA APPLICARE
                    EXECUTE PROCEDURE APPLICASCONTISPECIALINETTIPV(:CLIENTE,:FASCIA,:ARTICOLO,:ESTENSIONE,:QUANTITA,:DATA)
                    RETURNING_VALUES  :scontoSp,
                                      :scontounoSp,
                                      :scontodueSp,
                                      :scontotreSp,
                                      :IDPROMOVELOCE_SP;
                    IF (scontoSp IS NOT NULL)
                    THEN BEGIN
                        prezzoscontato=prezzoscontato-prezzoscontato*:scontosp/100;
            
                        IF (scontouno IS NULL OR scontouno=0) THEN
                        BEGIN
                           scontouno=scontounosp;
                           scontodue=scontoduesp;
                           scontotre=scontotresp;
                        END
                        ELSE IF (scontodue IS NULL OR scontodue=0) THEN
                        BEGIN
                           scontodue=scontosp;
                        END
                        ELSE IF (scontotre IS NULL OR scontotre=0) THEN
                        BEGIN
                           scontotre=scontosp;
                        END
                        ELSE
                        BEGIN
                           scontotre=100-((100-scontotre)/100*(100-scontounosp)/100*(100-scontoduesp)/100*(100-scontotresp));
                        END
    
                        sconto=100-((100-scontouno)/100*(100-scontodue)/100*(100-scontotre));
                        
                        IF(:IDPROMOVELOCE_SP IS NOT NULL AND :IDPROMOVELOCE_SP>0)THEN
                            IDPROMOVELOCE = :IDPROMOVELOCE_SP;
    
                    END
                END

                --CERCO EVENTUALE RICARICO DA APPLICARE
                EXECUTE PROCEDURE APPLICARICARICO(:FASCIA,:ARTICOLO,:ESTENSIONE,:QUANTITA,:DATA)
                RETURNING_VALUES  :RICARICOSP,:RICARICOUNOSP,:RICARICODUESP,:RICARICOTRESP;
                IF (ricaricoSp IS NOT NULL)
                THEN BEGIN
                    prezzoscontato=prezzoscontato+prezzoscontato*:ricaricoSp/100;
                    prezzonetto=prezzonetto+prezzonetto*:ricaricoSp/100;
                END
        
                IF(MIGLIORPREZZOMODE=1)THEN
                BEGIN
                    IF(migliorprezzoscontato IS NULL OR prezzoscontato<migliorprezzoscontato)THEN
                    BEGIN
                         migliorprezzoscontato=prezzoscontato;
                         migliorprezzonetto=prezzonetto;
                         migliorsconto=sconto;
                         migliorscontouno=scontouno;
                         migliorscontodue=scontodue;
                         migliorscontotre=scontotre;
                         migliorlistinorif=listino_rif;
                         migliorlistinoapp=listino_app;
                         migliorprovvigione=provvigione;
                    END
                END
                ELSE
                BEGIN

                    IF(provvigione IS NULL)THEN
                        provvigione=0;

                    SUSPEND;
                    EXIT;
                END
            
            
            END

        END

        NLISTINI=NLISTINI-1;
       
        
    END
    
    
    --MATTEO 2018 02 21 
    DSQL='SELECT COALESCE(COUNT(*),0) T FROM FASCESC WHERE ID='||FASCIA||' AND UPPER(CLASSIFICAZIONE2)=''STOCK''';
    EXECUTE STATEMENT DSQL INTO FASCESTOCK;
    
    IF(FASCESTOCK > 0)THEN
    BEGIN
        DSQL='SELECT COALESCE(CAST(TESTO AS INT),0) ID FROM TABX WHERE NOME=''ListinoStock''';
        EXECUTE STATEMENT DSQL INTO LISTINOSTOCK;
        
        DSQL='SELECT COALESCE(QUANTITASCAGLIONE,0) QTSTOCK, COALESCE(DATAINIZIOVALIDITA,''NOW'') DATAPROMO, COALESCE(PREZZO,0) PREZZOPROMO '||
        'FROM LISTSCDTNET '||
        'WHERE IDLISTSC='||LISTINOSTOCK||' AND CODICEARTICOLO='''||ARTICOLO||''' '||
        'AND (DATAINIZIOVALIDITA IS NULL OR DATAINIZIOVALIDITA<=''NOW'') AND (DATAFINEVALIDITA IS NULL OR DATAFINEVALIDITA>=''NOW'') '||
        'ORDER BY DATAINIZIOVALIDITA DESC';
        EXECUTE STATEMENT DSQL INTO QTSTOCK,DATAPROMOSTOCK,PREZZOPROMOSTOCK;
        
        IF(DATAPROMOSTOCK IS NOT NULL)THEN
        BEGIN
            DSQL='SELECT COALESCE(SUM(QUANTITAORDINE),0) TOT FROM LOGPROMOSTOCK WHERE CODICEARTICOLO='''||ARTICOLO||''' AND DATAPROMO='''||DATAPROMOSTOCK||''' AND STATUS=''ATTIVO''';
            EXECUTE STATEMENT DSQL INTO QCONSTOCK;
        
            QSTOCKUTILE = QTSTOCK - QCONSTOCK;
        END
    END



    --MATTEO 2012 03 26 se modalita miglior prezzo ritorno quello trovato (se trovato)
    IF(MIGLIORPREZZOMODE=1)THEN
    BEGIN
       IF(MIGLIORPREZZOSCONTATO IS NOT NULL OR MIGLIORPREZZOSCONTATO<>-1)THEN
       BEGIN
          prezzoscontato=migliorprezzoscontato;
          prezzonetto=migliorprezzonetto;
          sconto=migliorsconto;
          scontouno=migliorscontouno;
          scontodue=migliorscontodue;
          scontotre=migliorscontotre;
          listino_rif=migliorlistinorif;
          listino_app=migliorlistinoapp;
          provvigione=migliorprovvigione;
          
          IF(provvigione IS NULL)THEN
             provvigione=0;
          
          SUSPEND;
          EXIT;
       END
    END



    --MATTEO 2012 03 20
    --SE NON TROVO ALCUN PREZZO RITORNO QUELLO IN ANAMAG
    DSQL='SELECT  PREZZOVENDITA '||
    'FROM ANAMAG '||
    'WHERE CODICE='''||articolo||''' ';
    IF(estensione='0')THEN
       DSQL=DSQL||'AND (TRIM(ESTENSIONE)='''' OR ESTENSIONE IS NULL) ';
    ELSE
       DSQL=DSQL||'AND ESTENSIONE='''||estensione||''' ';
    

    EXECUTE STATEMENT DSQL INTO prezzonetto;
    prezzoscontato=prezzonetto;
    sconto=0;
    scontouno=0;
    scontodue=0;
    scontotre=0;
    provvigione=0;
    
    IF(prezzoscontato IS NULL)THEN
      prezzoscontato=0;
    
    IF(prezzonetto IS NULL)THEN
       prezzonetto=0;



    Listino_app=-1;
    --PREZZOscontato=-1;
    SUSPEND;
    
END^
SET TERM ; ^

